/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.launcher.loading;

import com.badlogic.gdx.files.FileHandle;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import technology.rocketjump.undermount.assets.entities.furniture.model.FurnitureEntityAsset;
import technology.rocketjump.undermount.assets.entities.humanoid.model.HumanoidEntityAsset;
import technology.rocketjump.undermount.assets.entities.item.model.ItemEntityAsset;
import technology.rocketjump.undermount.assets.entities.model.EntityAsset;
import technology.rocketjump.undermount.assets.entities.model.SpriteDescriptor;
import technology.rocketjump.undermount.assets.entities.plant.model.PlantEntityAsset;
import technology.rocketjump.undermount.assets.entities.wallcap.model.WallCapAsset;
import technology.rocketjump.undermount.entities.SequentialIdGenerator;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureCategory;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureLayout;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemType;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpecies;
import technology.rocketjump.undermount.launcher.model.EntityAssetManifest;

public class EntityAssetLoader {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public EntityAssetManifest parse(FileHandle baseAssetDir) throws IOException {
        EntityAssetManifest manifest = new EntityAssetManifest();
        for (FileHandle fileHandle : baseAssetDir.list()) {
            if (fileHandle.isDirectory() && fileHandle.name().equals("humanoid")) {
                this.parseChildDir(fileHandle, manifest, manifest.getHumanoidEntityAssets(), HumanoidEntityAsset.class);
                continue;
            }
            if (fileHandle.isDirectory() && fileHandle.name().equals("plant")) {
                this.parseChildDir(fileHandle, manifest, manifest.getPlantEntityAssets(), PlantEntityAsset.class);
                continue;
            }
            if (fileHandle.isDirectory() && fileHandle.name().equals("item")) {
                this.parseChildDir(fileHandle, manifest, manifest.getItemEntityAssets(), ItemEntityAsset.class);
                continue;
            }
            if (fileHandle.isDirectory() && fileHandle.name().equals("furniture")) {
                this.parseChildDir(fileHandle, manifest, manifest.getFurnitureEntityAssets(), FurnitureEntityAsset.class);
                continue;
            }
            if (fileHandle.isDirectory() && fileHandle.name().equals("wall_cap")) {
                this.parseChildDir(fileHandle, manifest, manifest.getWallCapAssets(), WallCapAsset.class);
                continue;
            }
            if (fileHandle.file().getName().equals("pack.json")) {
                manifest.setPackJsonFile(fileHandle);
                continue;
            }
            if (fileHandle.file().getName().equals("renderLayers.json")) {
                manifest.setRenderLayersJsonFile(fileHandle);
                continue;
            }
            if (!fileHandle.file().getName().equals("entityAssetTypes.json")) continue;
            manifest.setEntityAssetTypesJsonFile(fileHandle);
        }
        return manifest;
    }

    private <T extends EntityAsset> void parseChildDir(FileHandle entitySubdir, EntityAssetManifest manifest, List<T> assetsByTypeList, Class<T> entityClassType) throws IOException {
        if (entitySubdir.child("descriptor.json").exists() || entitySubdir.child("descriptors.json").exists()) {
            this.parseEntityFromDir(entitySubdir, manifest, assetsByTypeList, entityClassType);
            return;
        }
        for (FileHandle fileHandle : entitySubdir.list()) {
            if (fileHandle.isDirectory()) {
                this.parseChildDir(fileHandle, manifest, assetsByTypeList, entityClassType);
                continue;
            }
            if (fileHandle.name().equals("plant-species-descriptor.json")) {
                PlantSpecies plantSpecies = this.objectMapper.readValue(fileHandle.file(), PlantSpecies.class);
                this.parsePlantSpeciesDescriptor(plantSpecies, fileHandle.parent(), manifest);
                continue;
            }
            if (fileHandle.name().equals("plant-species-descriptors.json")) {
                List plantSpeciesList = (List)this.objectMapper.readValue(fileHandle.readString(), this.objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, PlantSpecies.class));
                for (PlantSpecies plantSpecies : plantSpeciesList) {
                    this.parsePlantSpeciesDescriptor(plantSpecies, fileHandle.parent(), manifest);
                }
                continue;
            }
            if (fileHandle.name().equals("item-type-descriptor.json")) {
                ItemType itemType = this.objectMapper.readValue(fileHandle.file(), ItemType.class);
                this.parseItemTypeDescriptor(itemType, manifest);
                continue;
            }
            if (fileHandle.name().equals("item-type-descriptors.json")) {
                List itemTypeList = (List)this.objectMapper.readValue(fileHandle.readString(), this.objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, ItemType.class));
                for (ItemType itemType : itemTypeList) {
                    this.parseItemTypeDescriptor(itemType, manifest);
                }
                continue;
            }
            if (fileHandle.name().equals("furniture-layouts.json")) {
                List layoutList = (List)this.objectMapper.readValue(fileHandle.readString(), this.objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, FurnitureLayout.class));
                manifest.getFurnitureLayoutList().addAll(layoutList);
                continue;
            }
            if (fileHandle.name().equals("furniture-categories.json")) {
                List categoryList = (List)this.objectMapper.readValue(fileHandle.readString(), this.objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, FurnitureCategory.class));
                manifest.getFurnitureCategoryList().addAll(categoryList);
                continue;
            }
            if (!fileHandle.name().equals("furniture-types.json")) continue;
            List furnitureTypes = (List)this.objectMapper.readValue(fileHandle.readString(), this.objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, FurnitureType.class));
            manifest.getFurnitureTypeList().addAll(furnitureTypes);
        }
    }

    private void parsePlantSpeciesDescriptor(PlantSpecies plantSpecies, FileHandle parentDir, EntityAssetManifest manifest) throws IOException {
        LinkedList<String> colorSwatchFilenames = new LinkedList<String>();
        colorSwatchFilenames.add(plantSpecies.getLeafColorSwatch());
        colorSwatchFilenames.add(plantSpecies.getBranchColorSwatch());
        if (!plantSpecies.isEvergreen()) {
            colorSwatchFilenames.add(plantSpecies.getLeafTransitionColorSwatch());
        }
        for (String colorSwatchFilename : colorSwatchFilenames) {
            FileHandle colorSwatchFile = parentDir.child(colorSwatchFilename);
            if (!colorSwatchFile.exists()) {
                throw new RuntimeException("Could not find " + colorSwatchFilename + " from plant species descriptor in " + parentDir.path());
            }
            if (manifest.getPlantColorSwatchFilenames().contains(colorSwatchFilename)) {
                throw new RuntimeException("Duplicate plant color swatch found with name " + colorSwatchFilename);
            }
            manifest.getPlantColorSwatchFiles().add(colorSwatchFile);
            manifest.getPlantColorSwatchFilenames().add(colorSwatchFilename);
        }
        plantSpecies.getBranchMaterial().setMaterialId(SequentialIdGenerator.nextId());
        plantSpecies.setSpeciesId(SequentialIdGenerator.nextId());
        manifest.getPlantSpeciesList().add(plantSpecies);
    }

    private void parseItemTypeDescriptor(ItemType itemType, EntityAssetManifest manifest) throws IOException {
        itemType.setItemTypeId(SequentialIdGenerator.nextId());
        manifest.getItemTypeList().add(itemType);
    }

    private <T extends EntityAsset> void parseEntityFromDir(FileHandle entityDir, EntityAssetManifest manifest, List<T> assetsByTypeList, Class<T> entityClassType) throws IOException {
        List<EntityAsset> descriptors;
        if (entityDir.child("descriptor.json").exists()) {
            EntityAsset entityAsset = (EntityAsset)this.objectMapper.readValue(entityDir.child("descriptor.json").file(), entityClassType);
            descriptors = new LinkedList<EntityAsset>();
            descriptors.add(entityAsset);
        } else {
            descriptors = (List)this.objectMapper.readValue(entityDir.child("descriptors.json").readString(), this.objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, entityClassType));
        }
        for (EntityAsset entityAssetDescriptor : descriptors) {
            for (SpriteDescriptor spriteDescriptor : entityAssetDescriptor.getSpriteDescriptors().values()) {
                if (spriteDescriptor.getIsAnimated()) {
                    FileHandle[] spriteFiles;
                    for (FileHandle spriteFile : spriteFiles = entityDir.list((dir, name) -> name.contains(spriteDescriptor.getFilename()) && !name.contains("NORMALS"))) {
                        this.addSpriteFile(entityDir, manifest, spriteDescriptor, spriteFile.name());
                    }
                    continue;
                }
                String spriteFilename = spriteDescriptor.getFilename();
                this.addSpriteFile(entityDir, manifest, spriteDescriptor, spriteFilename);
            }
            assetsByTypeList.add(entityAssetDescriptor);
        }
    }

    private void addSpriteFile(FileHandle entityDir, EntityAssetManifest manifest, SpriteDescriptor spriteDescriptor, String spriteFilename) throws IOException {
        if (entityDir.child(spriteFilename).exists()) {
            if (!manifest.getSpriteFilenames().contains(spriteFilename)) {
                manifest.getSpriteFilenames().add(spriteFilename);
                manifest.getEntitySpriteFiles().add(entityDir.child(spriteFilename));
                String normalMapFilename = spriteFilename.replace(".png", "_NORMALS.png");
                if (entityDir.child(normalMapFilename).exists()) {
                    manifest.getEntityNormalMapFiles().add(entityDir.child(normalMapFilename));
                }
            }
        } else {
            throw new IOException("Could not find file " + spriteDescriptor.getFilename() + " referenced in " + entityDir.file().getPath());
        }
    }
}

